/*******************************************************************/
/*                                                                 */
/*                      ADOBE CONFIDENTIAL                         */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                     */
/*                                                                 */
/* Copyright 1997 - 1999 Adobe Systems Incorporated                */
/* All Rights Reserved.                                            */
/*                                                                 */
/* NOTICE:  All information contained herein is, and remains the   */
/* property of Adobe Systems Incorporated and its suppliers, if    */
/* any.  The intellectual and technical concepts contained         */
/* herein are proprietary to Adobe Systems Incorporated and its    */
/* suppliers and may be covered by U.S. and Foreign Patents,       */
/* patents in process, and are protected by trade secret or        */
/* copyright law.  Dissemination of this information or            */
/* reproduction of this material is strictly forbidden unless      */
/* prior written permission is obtained from Adobe Systems         */
/* Incorporated.                                                   */
/*                                                                 */
/*******************************************************************/
//-------------------------------------------------------------------
//-------------------------------------------------------------------------------
//
//	File:
//		PIUActionParams.h
//
//
//	Description:
//		This library contains the headers for the macros, and
//		routines to simplify the use of suites and also some
//		helpful common plug-in functions. 
//
//	Use:
//		PIUBasic is intended to group common functions
//		into higher-level macros and routines to simplify
//		plug-in programming.
//
//		Most expect A4-globals to be set-up already, for
//		gStuff to be a valid pointer to your global structure's
//		parameter block, and, on Windows, for hDllInstance to
//		be a global handle reference to your plug-in DLL.
//
//	Version history:
//		Version 1.0.0	7/31/1997	Created for Photoshop 5.0
//			Written by Andrew Coven.
//
//-------------------------------------------------------------------------------

#ifndef __PIUActionParams_h__
#define __PIUActionParams_h__

#include "PIActions.h"

//-------------------------------------------------------------------------------
//	Definitions.
//-------------------------------------------------------------------------------

// This is defined in <AEObjects.h> but was accidentally not included in
// PIActions.h:
#ifndef typeObjectSpecifier
#define typeObjectSpecifier		0x6f626a20	// 'obj '
#endif
#ifndef formName
#define formName				0x6e616d65  // 'name'
#endif
#ifndef formAbsolutePosition
#define formAbsolutePosition 	0x696e6478	// 'indx'
#endif
#ifndef formRelativePosition
#define formRelativePosition	0x72656c65	//'rele'
#endif
#ifndef formPropertyID
#define formPropertyID			0x70726f70	//'prop'
#endif

//-------------------------------------------------------------------------------
//	Action parameters references.
//-------------------------------------------------------------------------------
class PIUActionParams_t
	{
	public:
		// Constructor:
		PIUActionParams_t
			(
			PIActionParameters * actionsParams
			);
			
		PIUActionParams_t();
		
		// Copy constructor:
		PIUActionParams_t
			(
			const PIUActionParams_t & source
			);
		
		// Assignment operator:
		PIUActionParams_t & operator= 
			(
			const PIUActionParams_t & source
			);
			
		// Destructor:
		~PIUActionParams_t ();
		
		// Check for validity of resource before using:
		bool ParamsValid();
		
		// Change the parameter block:
		void SetParamBlock
			(
			PIActionParameters * actionParams
			);
		
		// Clear out the parameter descriptor:
		SPErr ClearParamDescriptor();
		
		// Fill out param block with return descriptor:
		void SetReturnInfo
			(
			PIActionDescriptor descriptor,
			PIDialogRecordOptions recordInfo
			);
		
		void SetReturnInfo
			(
			PIActionDescriptor descriptor
			); // Sets recordInfo = dialogOptional.
			
		// Return the playback descriptor and info:
		SPErr GetPlayInfo
			(
			PIActionDescriptor * descriptor,
			PIDialogPlayOptions * playInfo
			);
		
		// Simpler methods for making and freeing a descriptor:
		PIActionDescriptor Make(void);
		void Free(PIActionDescriptor* descriptor);
		
		// Read a string from a descriptor and return it as a block
		// that you must free when you're done:
		char* GetString
			(
			PIActionDescriptor descriptor,
			DescriptorKeyID key
			);
					
	private:
		// None.
	
	protected:
		PIActionParameters * actionParams_;
	};

//-------------------------------------------------------------------------------
//	Errors.
//-------------------------------------------------------------------------------
#define kPSErrorUnknownStringID	'!sid'

//-------------------------------------------------------------------------------

#endif // __PIUActionParams_h__
